# delete_confirmation_popup.py
import tkinter as tk
from tkinter import ttk

class DeleteConfirmationPopup(tk.Toplevel):
    def __init__(self, parent, epc):
        super().__init__(parent)
        self.parent = parent
        self.epc = epc
        self.confirmed = False

        self.title("Delete Tag?")
        self.transient(parent)
        self.grab_set()
        
        main_frame = ttk.Frame(self, padding="20")
        main_frame.pack(fill="both", expand=True)

        message_frame = ttk.Frame(main_frame)
        message_frame.pack(pady=(0, 20))

        ttk.Label(message_frame, text=f"Do you really want to delete RFID", font=("Segoe UI", 10)).pack()
        ttk.Label(message_frame, text=self.epc, font=("Consolas", 9, "bold")).pack()
        ttk.Label(message_frame, text="\nAll tests done on it will be deleted together", font=("Segoe UI", 9, "italic")).pack()

        button_frame = ttk.Frame(main_frame)
        button_frame.pack()

        delete_button = ttk.Button(button_frame, text="Delete", command=self._confirm)
        delete_button.pack(side="left", padx=10)
        cancel_button = ttk.Button(button_frame, text="Cancel", command=self.destroy)
        cancel_button.pack(side="left", padx=10)

        self.bind("<Return>", lambda e: self._confirm())
        self.bind("<Escape>", lambda e: self.destroy())

    def _confirm(self):
        self.confirmed = True
        self.destroy()